#include "segment_embeddings_data_reader.h"

#include <crypta/lookalike/proto/segment_embedding.pb.h>

using namespace NCrypta::NLookalike::NIndexBuilder;

TSegmentEmbeddingsData NSegmentEmbeddingsDataReader::Read(NYT::IClientBasePtr client, const TString& path, size_t dimension) {
    TSegmentEmbeddingsDataBuilder builder;

    for (auto reader = client->CreateTableReader<TSegmentEmbedding>(path); reader->IsValid(); reader->Next()) {
        const auto& row = reader->GetRow();

        const auto& doubleEmbedding = row.GetEmbedding();
        TEmbedding embedding(doubleEmbedding.begin(), doubleEmbedding.end());

        Y_ENSURE(dimension == embedding.size(), "Row dimension is " << embedding.size() << " but expected " << dimension);

        builder.AddLabel(row.GetSegmentId());
        builder.AddData(embedding.data(), embedding.size() * sizeof(TEmbeddingComponent));
    }

    return builder.Build();
}
