EXECTEST()

OWNER(
    g:crypta
    g:crypta-lookalike
)

RUN(
    NAME testing_config
    CWD ${ARCADIA_ROOT}/crypta/lookalike/services/lal_manager/bundle/templates

    render_and_check_yaml
        --template config.yaml
        --output ${TEST_CASE_ROOT}/output.yaml
        --context '{"environment": "testing", "dc": "man", "topic": "crypta@test@lookalike--update-lal-fast-log", "scope": "direct", "describing_mode": "fast"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME stable_config
    CWD ${ARCADIA_ROOT}/crypta/lookalike/services/lal_manager/bundle/templates

    render_and_check_yaml
        --template config.yaml
        --output ${TEST_CASE_ROOT}/output.yaml
        --context '{"environment": "production", "dc": "sas", "topic": "crypta@prod@lookalike--update-lal-fast-log", "scope": "direct", "describing_mode": "fast"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME testing_qa
    CWD ${ARCADIA_ROOT}/crypta/lookalike/services/lal_manager/bundle/templates

    render_and_check_yaml
        --template config.yaml
        --output ${TEST_CASE_ROOT}/output.yaml
        --context '{"environment": "qa", "dc": "qa", "scope": "qa", "logbroker_server": "localhost", "logbroker_port": "20500", "topic": "lb-topic", "client_id": "lb-consumer", "self_tvm_id": "", "log_dir": "/tmp", "use_secure_tvm": false, "self_tvm_id": 1, "lal_database_cluster_url": "localhost", "static_yt_proxy": "localhost", "siberia_host": "localhost", "siberia_port": 80, "siberia_tvm_id": 1, "stats_check_interval_seconds": 1, "audience_segments_table_path": "//home/crypta/qa/audience/Stats", "cdp_segments_table_path": "//home/metrika/cdp/qa/export/user_segments", "yt_working_dir": "//home/crypta/qa", "describing_mode": "fast", "custom_audience_host": "localhost", "custom_audience_port": 8080}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

DATA(
    arcadia/crypta/lookalike/services/lal_manager/bundle/templates/config.yaml
)

DEPENDS(
    crypta/utils/render_and_check_yaml
)

END()
