#include "processor_factory.h"

#include <crypta/lookalike/services/lal_manager/commands/lal_cmd.pb.h>
#include <crypta/lookalike/services/lal_manager/lib/processors/add_lal_processor.h>
#include <crypta/lookalike/services/lal_manager/lib/processors/describe_lal_processor.h>
#include <crypta/lookalike/services/lal_manager/lib/processors/remove_lal_processor.h>
#include <crypta/lookalike/services/lal_manager/lib/processors/change_newness_processor.h>

#include <library/cpp/protobuf/json/json2proto.h>

using namespace NCrypta::NEventProcessing;
using namespace NCrypta::NLookalike;
using namespace NCrypta::NLookalike::NLalManager;

TProcessorFactory::TProcessorFactory(TLalProcessor::TConfig goalProcessorConfig, TStats& stats)
    : LalProcessorConfig(std::move(goalProcessorConfig))
    , Stats(stats)
{}

IProcessorPtr TProcessorFactory::Create(const TStringBuf& commandString) const {
    const auto& command = NProtobufJson::Json2Proto<TLalCmd>(commandString, {.AllowUnknownFields=false, .CastRobust=true});
    const auto& commandType = command.GetCmdCase();

    if (commandType == TLalCmd::kAddLalCmd) {
        return MakeHolder<TAddLalProcessor>(command.GetAddLalCmd(), LalProcessorConfig, Stats);
    } else if (commandType == TLalCmd::kDescribeLalCmd) {
        return MakeHolder<TDescribeLalProcessor>(command.GetDescribeLalCmd(), LalProcessorConfig, Stats);
    } else if (commandType == TLalCmd::kRemoveLalCmd) {
        return MakeHolder<TRemoveLalProcessor>(command.GetRemoveLalCmd(), LalProcessorConfig, Stats);
    } else if (commandType == TLalCmd::kChangeNewnessCmd) {
        return MakeHolder<TChangeNewnessProcessor>(command.GetChangeNewnessCmd(), LalProcessorConfig, Stats);
    }

    return nullptr;
}
