#include "add_lal_processor.h"

#include <crypta/lib/native/time/scope_timer.h>
#include <crypta/lookalike/proto/lal_parent.pb.h>

using namespace NCrypta::NLookalike;
using namespace NCrypta::NLookalike::NLalManager;

namespace {
    bool operator==(const TLalParent& lhs, const TLalParent& rhs) {
        return lhs.GetType() == rhs.GetType() && lhs.GetId() == rhs.GetId();
    }

    bool operator!=(const TLalParent& lhs, const TLalParent& rhs) {
        return !(lhs == rhs);
    }
}

TAddLalProcessor::TAddLalProcessor(
    TAddLalCmd command,
    TConfig config,
    ::TStats& stats
)
    : TBase(std::move(config), "TAddLalProcessor", stats)
    , Command(std::move(command))
{}

bool TAddLalProcessor::Process(TMaybe<TLalState> currentLalState) {
    TScopeTimer timer(Stats.Percentile, "processors.add_lal.timing.batch_processing");

    if (!currentLalState) {
        currentLalState = TLalState();
    }

    auto& currentLalStateValue = *currentLalState;
    auto& currentParent = *currentLalStateValue.MutableMeta()->MutableParent();
    const auto& newParent = Command.GetParent();

    const bool parentChanged = (newParent != currentParent);
    currentParent.CopyFrom(newParent);

    if (parentChanged || NeedToDescribe(currentLalStateValue)) {
        auto description = DescribeParent(newParent);
        if (description) {
            currentLalStateValue.MutableDescription()->Swap(&description->Description);
            currentLalStateValue.MutableMeta()->SetSize(description->Size);
            currentLalStateValue.MutableMeta()->SetNew(true);
        }
    }

    WriteLalState(currentLalStateValue);
    return true;
}

ui64 TAddLalProcessor::GetLalId() const {
    return Command.GetLalId();
}
