#include "change_newness_processor.h"

#include <crypta/lib/native/time/scope_timer.h>

using namespace NCrypta::NLookalike::NLalManager;

TChangeNewnessProcessor::TChangeNewnessProcessor(
    TChangeNewnessCmd command,
    TConfig config,
    ::TStats& stats
)
    : TBase(std::move(config), "TChangeNewnessProcessor", stats)
    , Command(std::move(command))
{}

bool TChangeNewnessProcessor::Process(TMaybe<TLalState> currentLalState) {
    TScopeTimer timer(Stats.Percentile, "processors.change_newness.timing.batch_processing");

    if (currentLalState) {
        auto& currentLalStateValue = *currentLalState;
        const auto& newnessState = Command.GetNewnessState();
        currentLalStateValue.MutableMeta()->SetNew(newnessState);
        WriteLalState(currentLalStateValue);
    }

    return true;
}

ui64 TChangeNewnessProcessor::GetLalId() const {
    return Command.GetLalId();
}
