#include "describe_lal_processor.h"

#include <crypta/lib/native/time/scope_timer.h>

using namespace NCrypta::NLookalike::NLalManager;

TDescribeLalProcessor::TDescribeLalProcessor(
    TDescribeLalCmd command,
    TConfig config,
    ::TStats& stats
)
    : TBase(std::move(config), "TDescribeLalProcessor", stats)
    , Command(std::move(command))
{}

bool TDescribeLalProcessor::Process(TMaybe<TLalState> currentLalState) {
    TScopeTimer timer(Stats.Percentile, "processors.describe_lal.timing.batch_processing");

    if (currentLalState) {
        auto& currentLalStateValue = *currentLalState;
        if (NeedToDescribe(currentLalStateValue)) {
            auto description = DescribeParent(currentLalStateValue.GetMeta().GetParent());
            if (description) {
                currentLalStateValue.MutableDescription()->Swap(&description->Description);
                currentLalStateValue.MutableMeta()->SetSize(description->Size);
                WriteLalState(currentLalStateValue);
            }
        }
    }

    return true;
}

ui64 TDescribeLalProcessor::GetLalId() const {
    return Command.GetLalId();
}
