#include "remove_lal_processor.h"

#include <crypta/lib/native/time/scope_timer.h>

using namespace NCrypta::NLookalike::NLalManager;

TRemoveLalProcessor::TRemoveLalProcessor(
    TRemoveLalCmd command,
    TConfig config,
    ::TStats& stats
)
    : TBase(std::move(config), "TRemoveLalProcessor", stats)
    , Command(std::move(command))
{}

bool TRemoveLalProcessor::Process(TMaybe<TLalState> currentLalState) {
    TScopeTimer timer(Stats.Percentile, "processors.remove_lal.timing.batch_processing");
    if (currentLalState) {
        RemoveLalState();
    }
    return true;
}

ui64 TRemoveLalProcessor::GetLalId() const {
    return Command.GetLalId();
}
