import datetime
import logging

from yt.wrapper import ypath

from crypta.lib.python.logging import logging_helpers
from crypta.lib.python.yt import yt_helpers
from crypta.lib.python import (
    time_utils,
    yaml_config,
)
from crypta.lookalike.services.lal_refresher.lib.config_pb2 import TConfig
from crypta.lookalike.services.lal_refresher.lib import refresher


logger = logging.getLogger(__name__)


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())
    logger.info("Refresh lals")
    config = yaml_config.parse_config_from_args(TConfig, "Refresh lals")

    yt_client = yt_helpers.get_yt_client(config.Yt.Proxy, config.Yt.Pool)
    err_path = ypath.ypath_join(config.ErrorsDir, str(int(time_utils.get_current_time())))

    with yt_client.Transaction():
        yt_helpers.create_folder(yt_client, config.ErrorsDir)

        yt_client.run_map(
            refresher.RefreshLalsMapper(config.Mapper, config.Tvm.SelfClientId),
            config.LalsPath,
            err_path,
            spec={
                'secure_vault': dict(TVM_SECRET=config.Tvm.Secret),
            }
        )

    yt_helpers.set_ttl(err_path, datetime.timedelta(days=config.ErrorsTtlDays), yt_client, remove_if_empty=True)

    logger.info("Done")
