EXECTEST()

OWNER(
    g:crypta
    g:crypta-lookalike
)

RUN(
    NAME stable_config
    CWD ${ARCADIA_ROOT}/crypta/lookalike/services/lal_synchronizer/bundle

    render_and_check_yaml
    --template config.yaml
    --output ${TEST_CASE_ROOT}/output.yaml
    --context '{"environment": "stable", "scope": "direct", "input_table": "//home/direct/export/crypta/lal_segments", "update_lal_fast_log": "update-lal-fast-log"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME testing_config
    CWD ${ARCADIA_ROOT}/crypta/lookalike/services/lal_synchronizer/bundle

    render_and_check_yaml
    --template config.yaml
    --output ${TEST_CASE_ROOT}/output.yaml
    --context '{"environment": "testing", "scope": "direct", "update_lal_fast_log": "update-lal-fast-log"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME qa_config
    CWD ${ARCADIA_ROOT}/crypta/lookalike/services/lal_synchronizer/bundle

    render_and_check_yaml
    --template config.yaml
    --output ${TEST_CASE_ROOT}/output.yaml
    --context '{"environment": "qa", "scope": "direct", "yt_proxy": "localhost", "lb_url": "localhost", "lb_port": 8080, "lb_topic": "default-topic", "input_table": "//home/qa/lookalike/input", "scope": "test_scope"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

DATA(
    arcadia/crypta/lookalike/services/lal_synchronizer/bundle/config.yaml
    arcadia/crypta/lookalike/services/lal_synchronizer/bundle/crypta-lookalike-lal-synchronizer.json
)

DEPENDS(
    crypta/utils/render_and_check_yaml
)

END()
