#include "convert_lal_state_mapper.h"

using namespace NCrypta::NLookalike;
using namespace NCrypta::NLookalike::NLalSynchronizer;

void TConvertLalStateMapper::Do(TReader* reader, TWriter* writer) {
    for (; reader->IsValid(); reader->Next()) {
        auto stateEntry = reader->MoveRow();

        const auto& parent = stateEntry.GetValue().GetMeta().GetParent();

        TInputLalEntry res;
        res.SetLalId(FromString<ui64>(stateEntry.GetKey()));
        res.SetParentType(parent.GetType());
        res.SetParentId(parent.GetId());
        if (parent.HasRule()) {
            res.SetParentRule(parent.GetRule());
        }

        writer->AddRow(res);
    }
}

REGISTER_MAPPER(TConvertLalStateMapper);
