#pragma once

#include "direct_entry_converter.h"

#include <crypta/lib/native/yt/utils/tables_indexes.h>
#include <crypta/lookalike/proto/error.pb.h>
#include <crypta/lookalike/proto/input_lal_entry.pb.h>
#include <crypta/lookalike/proto/lal_parent.pb.h>
#include <crypta/lookalike/proto/lal_state_key_value.pb.h>

#include <mapreduce/yt/interface/client.h>
#include <mapreduce/yt/interface/io.h>

namespace NCrypta::NLookalike::NLalSynchronizer {

enum class ESynchronizeLalsMapperOutputTables {
    Output,
    Errors
};

template<typename TConverter>
    class TSynchronizeLalsMapper : public NYT::IMapper<NYT::TTableReader<typename TConverter::TEntry>, NYT::TTableWriter<::google::protobuf::Message>> {
        using TBase = NYT::IMapper<NYT::TTableReader<typename TConverter::TEntry>, NYT::TTableWriter<::google::protobuf::Message>>;
    public:
        using EOutputTables = ESynchronizeLalsMapperOutputTables;
        using TOutputIndexes = TTablesIndexes<EOutputTables>;

        TSynchronizeLalsMapper() = default;
        TSynchronizeLalsMapper(TOutputIndexes outputIndexes)
            : OutputIndexes(std::move(outputIndexes))
        {}

        void Do(typename TBase::TReader* reader, typename TBase::TWriter* writer) override {
            for (; reader->IsValid(); reader->Next()) {
                try {
                    const auto& entry = TConverter::GetLalEntry(reader->GetRow());
                    if (entry) {
                        writer->AddRow(*entry, *OutputIndexes[EOutputTables::Output]);
                    }

                } catch(const std::exception& e) {
                    WriteError(writer, e.what());
                }
            }
        }

        Y_SAVELOAD_JOB(OutputIndexes);

    private:
        void WriteError(typename TBase::TWriter* writer, const TString& message) {
            TError error;
            error.SetMessage(message);

            writer->AddRow(error, *OutputIndexes[EOutputTables::Errors]);
        }

        TOutputIndexes OutputIndexes;
    };
}
