#pragma once

#include <crypta/lib/native/pqlib/producer.h>
#include <crypta/lib/native/yt/utils/tables_indexes.h>
#include <crypta/lookalike/proto/error.pb.h>
#include <crypta/lookalike/proto/input_lal_entry.pb.h>
#include <crypta/lookalike/proto/lal_parent.pb.h>
#include <crypta/lookalike/services/lal_synchronizer/proto/reducer_config.pb.h>

#include <mapreduce/yt/interface/client.h>

#include <util/datetime/base.h>

namespace NCrypta::NLookalike::NLalSynchronizer {
class TSynchronizeLalsReducer : public NYT::IReducer<NYT::TTableReader<TInputLalEntry>, NYT::TTableWriter<TError>> {
    public:
        enum class EInputTables {
            Input,
            State
        };
        using TInputIndexes = TTablesIndexes<EInputTables>;

        TSynchronizeLalsReducer() = default;
        TSynchronizeLalsReducer(TReducerConfig config, TInputIndexes inputIndexes);

        void Start(TWriter* writer) override;
        void Finish(TWriter* writer) override;
        void Do(TReader* reader, TWriter* writer) override;

        Y_SAVELOAD_JOB(Config, InputIndexes);

    private:
        void AddLal(ui64 lalId, TLalParent&& parent);
        void RemoveLal(ui64 lalId);

        void WriteError(TWriter* writer, const TString& message);

        TReducerConfig Config;
        THolder<NCrypta::NPQ::TProducer> Producer;
        TInputIndexes InputIndexes;
    };
}
