#include <crypta/lookalike/services/lal_synchronizer/lib/direct_entry_converter.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NCrypta::NLookalike;
using namespace NCrypta::NLookalike::NLalSynchronizer;

Y_UNIT_TEST_SUITE(TDirectEntryConverter) {
    Y_UNIT_TEST(Basic) {
        TDirectEntry entry;
        entry.SetLalId(1'500'000'000);
        entry.SetGoalId(4'000'000'001);
        entry.SetIsActive(true);

        auto res = *TDirectEntryConverter::GetLalEntry(entry);

        UNIT_ASSERT_EQUAL(res.GetLalId(), entry.GetLalId());
        UNIT_ASSERT_EQUAL(res.GetParentId(), 1);
        UNIT_ASSERT_EQUAL(res.GetParentType(), TLalParent::METRIKA_COUNTER);
    }

    Y_UNIT_TEST(Inactive) {
        TDirectEntry entry;
        entry.SetLalId(1'500'000'000);
        entry.SetGoalId(4'000'000'001);
        entry.SetIsActive(false);

        UNIT_ASSERT(TDirectEntryConverter::GetLalEntry(entry).Empty());
    }

    Y_UNIT_TEST(RetargetingIdParent) {
        TDirectEntry entry;
        entry.SetLalId(1'500'000'000);
        entry.SetGoalId(4'000'000'001);
        entry.SetIsActive(true);
        entry.SetParentType("retargeting_id");

        auto res = *TDirectEntryConverter::GetLalEntry(entry);

        UNIT_ASSERT_EQUAL(res.GetLalId(), entry.GetLalId());
        UNIT_ASSERT_EQUAL(res.GetParentId(), 1);
        UNIT_ASSERT_EQUAL(res.GetParentType(), TLalParent::METRIKA_COUNTER);
    }

    Y_UNIT_TEST(CaParent) {
        TDirectEntry entry;
        entry.SetLalId(1'500'000'000);
        entry.SetGoalId(123);
        entry.SetIsActive(true);
        entry.SetParentType("custom_audience");
        entry.SetParentRule("parent_rule");

        auto res = *TDirectEntryConverter::GetLalEntry(entry);

        UNIT_ASSERT_EQUAL(res.GetLalId(), entry.GetLalId());
        UNIT_ASSERT_EQUAL(res.GetParentId(), 123);
        UNIT_ASSERT_EQUAL(res.GetParentType(), TLalParent::CUSTOM_AUDIENCE);
        UNIT_ASSERT_EQUAL(res.GetParentRule(), entry.GetParentRule());
    }

    Y_UNIT_TEST(WrongLalId) {
        TDirectEntry entry;
        entry.SetLalId(1'499'999'999);
        entry.SetGoalId(4'000'000'001);
        entry.SetIsActive(true);

        UNIT_ASSERT_EXCEPTION(TDirectEntryConverter::GetLalEntry(entry), yexception);
    }

    Y_UNIT_TEST(WrongGoalId) {
        TDirectEntry entry;
        entry.SetLalId(1'500'000'000);
        entry.SetGoalId(10);
        entry.SetIsActive(true);

        UNIT_ASSERT_EXCEPTION(TDirectEntryConverter::GetLalEntry(entry), yexception);
    }

    Y_UNIT_TEST(UnknownParentType) {
        TDirectEntry entry;
        entry.SetLalId(1'500'000'000);
        entry.SetGoalId(123);
        entry.SetIsActive(true);
        entry.SetParentType("unknown_parent_type");
        entry.SetParentRule("parent_rule");

        UNIT_ASSERT_EXCEPTION(TDirectEntryConverter::GetLalEntry(entry), yexception);
    }

    Y_UNIT_TEST(EmptyParentRuleType) {
        TDirectEntry entry;
        entry.SetLalId(1'500'000'000);
        entry.SetGoalId(123);
        entry.SetIsActive(true);
        entry.SetParentType("custom_audience");

        UNIT_ASSERT_EXCEPTION(TDirectEntryConverter::GetLalEntry(entry), yexception);
    }
}
