import logging

from yt.wrapper import ypath

from crypta.lookalike.lib.python.utils import directory_finder
from crypta.lookalike.proto.yt_node_names_pb2 import TYtNodeNames
from crypta.lookalike.services.metrics.counts_per_parent_type_calc.lib import executer
from crypta.lookalike.services.metrics.counts_per_parent_type_calc.lib.config_pb2 import TConfig
from crypta.lib.python import yaml_config
from crypta.lib.python.logging import logging_helpers
from crypta.lib.python.proto_secrets import proto_secrets
from crypta.lib.python.yt import yt_helpers


logger = logging.getLogger(__name__)


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())
    config = yaml_config.parse_config_from_args(TConfig, "Calculate LAL segment counts per parent type")

    logger.info("Config:\n%s", proto_secrets.get_copy_without_secrets(config))

    yt_client = yt_helpers.get_yt_client(config.Yt.Proxy, config.Yt.Pool)

    segment_metas_table_name = TYtNodeNames().SegmentMetasTable
    working_dir = directory_finder.find_last_with_children(yt_client, config.VersionsDir, [segment_metas_table_name])

    executer.calc_metrics(
        config.Yt,
        ypath.ypath_join(working_dir, segment_metas_table_name),
        config.MetricsTable,
        logger
    )

    logger.info("Completed successfully")
