from yt.wrapper import ypath

from crypta.lookalike.lib.python.utils import directory_finder
from crypta.lookalike.proto.yt_node_names_pb2 import TYtNodeNames
from crypta.lookalike.services.metrics.sizes_diff_calc.lib import executer
from crypta.lookalike.services.metrics.sizes_diff_calc.lib.config_pb2 import TConfig
from crypta.lib.python import runner
from crypta.lib.python.solomon import reporter
from crypta.lib.python.yt import yt_helpers


def calc_sizes_diff(config, logger):
    yt_client = yt_helpers.get_yt_client(config.Yt.Proxy, config.Yt.Pool)

    segment_metas_table_name = TYtNodeNames().SegmentMetasTable
    working_dir = directory_finder.find_last_with_children(yt_client, config.VersionsDir, [segment_metas_table_name])

    sizes_ratio_percentiles = executer.calc_metrics(
        config.Yt,
        config.AudienceSegmentsTable,
        ypath.ypath_join(working_dir, segment_metas_table_name),
        config.SizesTable,
        logger
    )

    solomon_reporter = reporter.create_solomon_reporter_from_config(config.Solomon)

    for percentile, value in sizes_ratio_percentiles.iteritems():
        solomon_reporter.set_value("sizes_ratio", value, labels={"percentile": percentile})


def main():
    runner.run(calc_sizes_diff, TConfig, "Calc LAL sizes diff")
