#!/usr/bin/env python
# -*- coding: utf-8 -*-

import logging

from crypta.lib.python import templater
from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction
from crypta.lookalike.lib.python.utils import mobile_utils
from crypta.lookalike.lib.python.utils.mobile_config import config as mobile_config

logger = logging.getLogger(__name__)


def calculate(nv_params):
    yt_client = mobile_utils.get_yt_client(nv_params=nv_params)
    yql_client = mobile_utils.get_yql_client(nv_params=nv_params)

    with NirvanaTransaction(yt_client) as transaction:
        query = templater.render_template(
            mobile_utils.affinitive_apps_calculation_query_template,
            vars={
                'type': 'app',
                'input_table': mobile_config.DEVID_BY_APP_TABLE,
                'devids_apps_weights': mobile_config.DEVIDS_APPS_WEIGHTS_TABLE,
                'affinities_table': mobile_config.APPS_AFFINITIES,
                'affinities_count': mobile_config.APPS_AFFINITIES_COUNT,
            },
        )

        yql_client.execute(
            query=query,
            transaction=str(transaction.transaction_id),
            title='YQL calculate affinitive apps',
        )
