#!/usr/bin/env python
# -*- coding: utf-8 -*-

import logging

from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction
from crypta.lib.python.yt import yt_helpers
from crypta.lookalike.lib.python.utils import mobile_utils
from crypta.lookalike.lib.python.utils.mobile_config import config as mobile_config

logger = logging.getLogger(__name__)

get_top_common_apps_query = """
INSERT INTO `{output_table}`
WITH TRUNCATE

(
    SELECT
        app_id,
        id_type,
        game,
        devids_cnt,
        'top_gaid_nogame' AS source
    FROM `{merged_stores}`
    WHERE id_type == 'gaid' AND game == False
    ORDER BY devids_cnt DESC
    LIMIT {DEVIDS_CNT_GAID}
)
UNION ALL
(
    SELECT
        app_id,
        id_type,
        game,
        devids_cnt,
        'top_gaid_game' AS source
    FROM `{merged_stores}`
    WHERE id_type == 'gaid' AND game == True
    ORDER BY devids_cnt DESC
    LIMIT {DEVIDS_CNT_GAID}
)
UNION ALL
(
    SELECT
        app_id,
        id_type,
        game,
        devids_cnt,
        'top_idfa_nogame' AS source
    FROM `{merged_stores}`
    WHERE id_type == 'idfa' AND game == False
    ORDER BY devids_cnt DESC
    LIMIT {DEVIDS_CNT_IDFA}
)
UNION ALL
(
    SELECT
        app_id,
        id_type,
        game,
        devids_cnt,
        'top_idfa_game' AS source
    FROM `{merged_stores}`
    WHERE id_type == 'idfa' AND game == True
    ORDER BY devids_cnt DESC
    LIMIT {DEVIDS_CNT_IDFA}
);

"""

select_apps_for_training_query = """
$apps = (
    (
        SELECT
            app_id,
            id_type,
            devids_cnt,
            RANDOM(app_id) AS shuffling_number,
            'monetized' as source
        FROM `{merged_stores}`
        WHERE (has_purchases == True OR has_ads == True OR price > 0) AND devids_cnt >= {MIN_DEVIDS_CNT}
        ORDER BY shuffling_number
        LIMIT {APPS_FOR_TRAINING_CNT}
    )
    UNION ALL
    (
        SELECT
            app_id,
            id_type,
            devids_cnt,
            RANDOM(app_id) AS shuffling_number,
            'top_common' AS source
        FROM `{top_common_apps_table}`
        WHERE devids_cnt >= {MIN_DEVIDS_CNT}
    )
    UNION ALL
    (
        SELECT
            app_id,
            id_type,
            devids_cnt,
            RANDOM(app_id) AS shuffling_number,
            'promoted' AS source
        FROM `{promoted_apps_table}`
        WHERE devids_cnt >= {MIN_DEVIDS_CNT}
    )
    UNION ALL
    (
        SELECT
            app_id,
            id_type,
            devids_cnt,
            RANDOM(app_id) AS shuffling_number,
            'idfa' AS source
        FROM `{merged_stores}`
        WHERE id_type == 'idfa' AND devids_cnt >= {MIN_DEVIDS_CNT}
        ORDER BY shuffling_number
        LIMIT {APPS_FOR_TRAINING_CNT}
    )
    UNION ALL
    (
        SELECT
            merged_stores.app_id AS app_id,
            merged_stores.id_type AS id_type,
            merged_stores.devids_cnt AS devids_cnt,
            RANDOM(merged_stores.app_id) AS shuffling_number,
            'with_vector' AS source,
        FROM `{app2vec_table}` AS app2vec
        INNER JOIN `{merged_stores}` AS merged_stores
        ON String::AsciiToLower(merged_stores.app_id) == app2vec.app
            AND merged_stores.id_type == app2vec.id_type
        WHERE devids_cnt >= {MIN_DEVIDS_CNT}
        ORDER BY shuffling_number
        LIMIT 3 * {APPS_FOR_TRAINING_CNT}
    )
    UNION ALL
    (
        SELECT
            app_id,
            id_type,
            devids_cnt,
            RANDOM(app_id) AS shuffling_number,
            'all' AS source
        FROM `{merged_stores}`
        WHERE devids_cnt >= {MIN_DEVIDS_CNT}
        ORDER BY shuffling_number
        LIMIT {APPS_FOR_TRAINING_CNT}
    )
);

$apps = (
    SELECT
        app_id,
        id_type,
        SOME(devids_cnt) AS devids_cnt,
        MAX(source) AS source,
        RANDOM(app_id) AS shuffling_number
    FROM $apps
    GROUP BY app_id, id_type
);

INSERT INTO `{apps_counts}`
WITH TRUNCATE

SELECT
    String::JoinFromList(AsList('train_apps', id_type), '_') AS counter_name,
    COUNT(*) AS `count`
FROM $apps
GROUP BY id_type;

$val_apps = (
    SELECT *
    FROM $apps
    ORDER BY shuffling_number
    LIMIT {VALIDATION_APPS_CNT}
);

INSERT INTO `{validation_apps_table}`
WITH TRUNCATE

SELECT *
FROM $val_apps;

INSERT INTO `{train_apps_table}`
WITH TRUNCATE

SELECT *
FROM $apps AS all_apps
LEFT ONLY JOIN $val_apps AS val_apps
USING (app_id, id_type);
"""


def select(nv_params):
    yt_client = mobile_utils.get_yt_client(nv_params=nv_params)
    yql_client = mobile_utils.get_yql_client(nv_params=nv_params)

    with NirvanaTransaction(yt_client) as transaction,\
            yt_client.TempTable() as apps_counts_table, \
            yt_client.TempTable() as campaign_apps_stats_table:
        yql_client.execute(
            query='{top_common}{promoted}'.format(
                top_common=get_top_common_apps_query.format(
                    merged_stores=mobile_config.MERGED_STORES,
                    output_table=mobile_config.TOP_COMMON_APPS,
                    DEVIDS_CNT_GAID=mobile_config.DEVIDS_CNT_GAID,
                    DEVIDS_CNT_IDFA=mobile_config.DEVIDS_CNT_IDFA,
                ),
                promoted=mobile_utils.get_promoted_apps_query.format(
                    input_table=mobile_config.CAMPAIGNS_STATISTICS,
                    merged_stores=mobile_config.MERGED_STORES,
                    campaign_apps_stats=campaign_apps_stats_table,
                    output_table=mobile_config.PROMOTED_APPS,
                    MIN_DEVIDS_NUMBER=mobile_config.MIN_DEVIDS_COUNT,
                ),
            ),
            transaction=str(transaction.transaction_id),
            title='YQL get top common apps and promoted apps',
        )

        yql_client.execute(
            query=select_apps_for_training_query.format(
                merged_stores=mobile_config.MERGED_STORES,
                MIN_DEVIDS_CNT=mobile_config.MIN_DEVIDS_COUNT,
                app2vec_table=mobile_config.APP2VEC_TABLE,
                promoted_apps_table=mobile_config.PROMOTED_APPS,
                top_common_apps_table=mobile_config.TOP_COMMON_APPS,
                APPS_FOR_TRAINING_CNT=mobile_config.APPS_FOR_TRAINING_COUNT,
                VALIDATION_APPS_CNT=mobile_config.VALIDATION_APPS_CNT,
                train_apps_table=mobile_config.TRAIN_APPS_TABLE,
                validation_apps_table=mobile_config.VALIDATION_APPS_TABLE,
                apps_counts=apps_counts_table,
            ),
            transaction=str(transaction.transaction_id),
            title='YQL get apps for training',
        )

        today_counts = list(yt_client.read_table(apps_counts_table))
        yt_helpers.write_stats_to_yt(
            yt_client=yt_client,
            table_path=mobile_config.DATALENS_MOBILE_LAL_COUNTERS_TABLE,
            data_to_write=today_counts,
            schema={
                'fielddate': 'string',
                'counter_name': 'string',
                'count': 'uint64',
            },
            date=mobile_utils.get_date_from_nv_parameters(nv_params=nv_params),
        )
