#!/usr/bin/env python
# -*- coding: utf-8 -*-

import logging

from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction
from crypta.lookalike.lib.python.utils import utils
from crypta.lookalike.lib.python.utils.mobile_config import config as mobile_config

logger = logging.getLogger(__name__)


get_current_centroid_vector = """
$get_store_id = ($id_type) -> {{
    RETURN
        CASE
            WHEN $id_type == 'idfa' THEN 'itunes'
            WHEN $id_type == 'gaid' THEN 'google_play'
            ELSE 'other'
        END
}};

$centroids_with_vectors = (
    SELECT
        cluster_id,
        store_id,
        centroid_ids.0 AS centroid_rank,
        centroid_ids.1 AS centroid_id,
        vectors.app_vector AS app_vector,
        centroids.centroids_bundle_ids AS old_centroids_bundle_ids,
    FROM `{cluster_centroids}` AS centroids
    FLATTEN DICT BY (ToDict(ListEnumerate(centroids.centroids_bundle_ids)) AS centroid_ids)
    LEFT JOIN ANY `{dssm_vectors}` AS vectors
    ON $get_store_id(vectors.id_type) == centroids.store_id AND vectors.app_id == centroids.centroid_ids.1
    WHERE app_vector IS NOT NULL
);

INSERT INTO `{output_table}`
WITH TRUNCATE
SELECT
    cluster_id,
    store_id,
    MIN(centroid_rank) AS centroid_rank,
    MIN_BY(centroid_id, centroid_rank) AS centroid_id,
    MIN_BY(app_vector, centroid_rank) AS centroid_vector,
    MIN_BY(old_centroids_bundle_ids, centroid_rank) AS old_centroids_bundle_ids,
FROM $centroids_with_vectors
GROUP BY cluster_id, store_id
ORDER BY store_id, cluster_id;
"""


def get(nv_params):
    yt_client = utils.get_yt_client(nv_params=nv_params)
    yql_client = utils.get_yql_client(nv_params=nv_params)

    if not mobile_config.is_production:
        yt_client.copy(
            mobile_config.APP_DSSM_VECTORS.replace('testing', 'production'),
            mobile_config.APP_DSSM_VECTORS,
            force=True,
        )

    with NirvanaTransaction(yt_client) as transaction:
        yql_client.execute(
            query=get_current_centroid_vector.format(
                dssm_vectors=mobile_config.APP_DSSM_VECTORS,
                cluster_centroids=mobile_config.CLUSTERS_INFO,
                output_table=mobile_config.CLUSTER_CENTROIDS_VECTORS,
            ),
            transaction=str(transaction.transaction_id),
            title='YQL Match existing centroids to new LaL apps vectors',
        )

    logger.info('New centroid vectors are matched to clusters')
