#!/usr/bin/env python
# -*- coding: utf-8 -*-

import logging

from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction
from crypta.lookalike.lib.python.utils import mobile_utils
from crypta.lookalike.lib.python.utils.mobile_config import config as mobile_config

logger = logging.getLogger(__name__)


def get(nv_params):
    yt_client = mobile_utils.get_yt_client(nv_params=nv_params)
    yql_client = mobile_utils.get_yql_client(nv_params=nv_params)

    with NirvanaTransaction(yt_client) as transaction:
        yql_client.execute(
            query=mobile_utils.get_users_by_crypta_id_query.format(
                idfa_to_crypta_id_matching=mobile_config.IDFA_TO_CRYPTA_ID_MATCHING,
                gaid_to_crypta_id_matching=mobile_config.GAID_TO_CRYPTA_ID_MATCHING,
                apps_by_devid=mobile_config.APPS_BY_DEVID_MONTHLY,
                apps_by_devid_with_crypta_id=mobile_config.APPS_BY_DEVID_AND_CRYPTA_ID,
                crypta_id_to_id_type=mobile_config.CRYPTA_ID_TO_ID_TYPE,
                devid_by_app_with_crypta_id=mobile_config.DEVID_BY_APP_WITH_CRYPTA_ID,
                merged_stores=mobile_config.MERGED_STORES_RAW,
                input_for_apps_description=mobile_config.APPS_SEGMENTS,
                additional_options='' if mobile_config.is_production else 'LIMIT 100000',
            ),
            transaction=str(transaction.transaction_id),
            title='YQL get monthly users with crypta_id.',
        )
