#!/usr/bin/env python
# -*- coding: utf-8 -*-

import json
import logging

from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction
from crypta.lib.python.yt import yt_helpers
from crypta.lookalike.lib.python.utils import (
    fields,
    mobile_utils,
)
from crypta.lookalike.lib.python.utils.mobile_config import config as mobile_config
from crypta.lookalike.lib.python.utils.utils import get_features_mapping_dict

logger = logging.getLogger(__name__)


def get(nv_params, output):
    yt_client = mobile_utils.get_yt_client(nv_params=nv_params)
    yql_client = mobile_utils.get_yql_client(nv_params=nv_params)

    with NirvanaTransaction(yt_client) as transaction:
        features_mapping = get_features_mapping_dict(yt_client, yql_client, mobile_config.LAL_FEATURES_MAPPING_TABLE, transaction)

        yt_helpers.create_empty_table(
            yt_client=yt_client,
            path=mobile_config.USERS_DSSM_FEATURES_WEB,
            schema={
                fields.cryptaId: 'uint64',
                fields.user_web_features: 'string',
            },
            additional_attributes={'optimize_for': 'scan'},
            force=True,
        )

        yt_client.run_map(
            mobile_utils.MakeDssmUserFeaturesMapper(main_field_name='CryptaID', features_mapping=features_mapping),
            mobile_config.USER_DATA_BY_CRYPTA_ID,
            mobile_config.USERS_DSSM_FEATURES_WEB,
            spec={
                'title': 'LaL convert UserData by crypta_id to dssm features',
                'job_io': {'table_reader': {'sampling_rate': mobile_config.USER_DATA_SAMPLING_RATE}},
            },
        )

    logger.info('Converted UserData to dssm features')

    with open(output, 'w') as output_file:
        json.dump({'ParamsSize': mobile_config.EMBEDDING_FEATURES_SIZE + len(features_mapping)}, output_file)

    logger.info('Successfully dumped features size')
