#pragma once

#include <crypta/lib/native/pqlib/producer.h>
#include <crypta/lib/native/proto_serializer/proto_serializer.h>
#include <crypta/lib/native/yt/utils/tables_indexes.h>
#include <crypta/lib/proto/user_data/user_data_stats.pb.h>
#include <crypta/lookalike/lib/native/segment_embedding_model.h>
#include <crypta/lookalike/proto/lal_state_key_value.pb.h>
#include <crypta/lookalike/proto/mode.pb.h>
#include <crypta/lookalike/proto/segment_embedding.pb.h>
#include <crypta/lookalike/proto/segment_meta_entry.pb.h>
#include <crypta/lookalike/services/segment_dssm_applier/proto/mapper_config.pb.h>

#include <mapreduce/yt/interface/client.h>

#include <util/datetime/base.h>

namespace NCrypta::NLookalike::NSegmentDssmApplier {
class TApplySegmentDssmMapper : public NYT::IMapper<NYT::TTableReader<TLalStateKeyValue>, NYT::TTableWriter<::google::protobuf::Message>> {
    public:
        enum class EOutputTables {
            Errors,
            SegmentEmbeddings,
            SegmentParentMeta
        };

        using TOutputIndexes = TTablesIndexes<EOutputTables>;

        TApplySegmentDssmMapper() = default;
        TApplySegmentDssmMapper(TMapperConfig config, TOutputIndexes outputIndexes);

        void Start(TWriter* writer) override;
        void Finish(TWriter* writer) override;
        void Do(TReader* reader, TWriter* writer) override;

        static TOutputIndexes PrepareOutput(NYT::TMapOperationSpec& spec, const TString& embeddings, const TString& metas, const TString& errors);

        Y_SAVELOAD_JOB(Config, OutputIndexes);

    private:
        void ChangeNewness(ui64 lalId);

        void WriteEmbedding(TWriter* writer, ui64 segmentId, const TEmbedding& embedding);
        void WriteParentMeta(TWriter* writer, ui64 segmentId, TSegmentMeta& meta);
        void WriteError(TWriter* writer, TMaybe<ui64> segmentId, const TString& message);

        TMapperConfig Config;
        TOutputIndexes OutputIndexes;
        THolder<NCrypta::NPQ::TProducer> Producer;
        THolder<TSegmentEmbeddingModel> SegmentEmbeddingModel;
        ModeValue Mode;
    };
}
