#pragma once

#include <crypta/lib/native/yt/utils/tables_indexes.h>
#include <crypta/lookalike/lib/native/hnsw_index_model.h>
#include <crypta/lookalike/proto/user_embedding.pb.h>
#include <crypta/lookalike/services/segmentator/proto/make_segments_mapper_config.pb.h>

#include <mapreduce/yt/interface/client.h>

#include <util/datetime/base.h>

namespace NCrypta::NLookalike::NSegmentator {
class TMakeSegmentsMapper : public NYT::IMapper<NYT::TTableReader<TUserEmbedding>, NYT::TTableWriter<::google::protobuf::Message>> {
    public:
        enum class EOutputTables {
            Segments,
            Errors
        };

        using TOutputIndexes = TTablesIndexes<EOutputTables>;

        TMakeSegmentsMapper() = default;
        TMakeSegmentsMapper(TOutputIndexes outputIndexes, TMakeSegmentsMapperConfig config);

        void Start(TWriter* writer) override;
        void Do(TReader* reader, TWriter* writer) override;

        static TOutputIndexes PrepareOutput(NYT::TMapOperationSpec& spec, const TString& segments, const TString& errors);

        Y_SAVELOAD_JOB(OutputIndexes, Config);

    private:
        void WriteSegments(TWriter* writer, ui64 userId, const THnswIndexModel::TNeighbors& neighbors);
        void WriteError(TWriter* writer, const TString& message);

        TOutputIndexes OutputIndexes;
        TMakeSegmentsMapperConfig Config;
        THolder<THnswIndexModel> HnswIndexModel;
    };
}
