import json
import logging

from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction
from crypta.lookalike.lib.python.utils import (
    mobile_utils,
    utils,
)
from crypta.lookalike.lib.python.utils.mobile_config import config as mobile_config

logger = logging.getLogger(__name__)


def get_features(yt_client, nv_params, input_file, input_table, output_table):
    if mobile_utils.check_date(yt_client, output_table, nv_params):
        logger.info('Features have already been calculated')
        return

    with NirvanaTransaction(yt_client) as transaction, \
         yt_client.TempTable() as userdata_stats:
        utils.describe_segments_in_siberia(
            yt_client,
            input_table,
            userdata_stats,
            mobile_config.ALL_CRYPTAID_TABLE_FOR_DESCRIPTION,
            transaction,
        )

        with open(input_file, 'r') as dict_file:
            features_mapping = json.load(dict_file)

        utils.get_segment_dssm_features(yt_client, userdata_stats, output_table, features_mapping)
        mobile_utils.set_generate_date(yt_client, output_table, nv_params)


def get_for_apps(nv_params, input_file):
    yt_client = mobile_utils.get_yt_client(nv_params=nv_params)
    get_features(yt_client, nv_params, input_file, mobile_config.APPS_SEGMENTS, mobile_config.APPS_FEATURES)


def get_for_installers_by_ad(nv_params, input_file):
    yt_client = mobile_utils.get_yt_client(nv_params=nv_params)

    if mobile_utils.check_date(yt_client, mobile_config.INSTALLS_BY_AD_SCORES, nv_params,
                               gap_days=mobile_config.PERIOD_TO_CALCULATE_INSTALLERS_BY_AD):
        logger.info('Scores for installers by ad segments are not calculated today')
        return

    if mobile_utils.check_date(yt_client, mobile_config.INSTALLERS_BY_AD_FEATURES, nv_params):
        logger.info('Features for installers by ad are ready')
        return

    get_features(
        yt_client,
        nv_params,
        input_file,
        mobile_config.INSTALLERS_BY_AD_SEGMENTS,
        mobile_config.INSTALLERS_BY_AD_FEATURES,
    )
