import logging

from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction
from crypta.lookalike.lib.python.utils import mobile_utils
from crypta.lookalike.lib.python.utils.mobile_config import config as mobile_config

logger = logging.getLogger(__name__)


def get_daily(nv_params):
    yt_client = mobile_utils.get_yt_client(nv_params=nv_params)
    yql_client = mobile_utils.get_yql_client(nv_params=nv_params)

    if mobile_utils.check_date(yt_client, mobile_config.APPS_SEGMENTS, nv_params):
        logger.info('Apps segments and daily users tables for description for today are ready.')
        return

    with NirvanaTransaction(yt_client) as transaction:
        yql_client.execute(
            query=mobile_utils.get_users_by_crypta_id_query.format(
                idfa_to_crypta_id_matching=mobile_config.IDFA_TO_CRYPTA_ID_MATCHING,
                gaid_to_crypta_id_matching=mobile_config.GAID_TO_CRYPTA_ID_MATCHING,
                apps_by_devid=mobile_config.APPS_BY_DEVID_DAILY,
                crypta_id_to_id_type=mobile_config.CRYPTA_ID_TO_ID_TYPE,
                devid_by_app_with_crypta_id=mobile_config.DEVID_BY_APP_WITH_CRYPTA_ID_DAILY,
                app_data=mobile_config.APP_DATA,
                apps_segments=mobile_config.APPS_SEGMENTS,
                additional_options='' if mobile_config.is_production else 'LIMIT 100000',
            ),
            transaction=str(transaction.transaction_id),
            title='YQL get daily users with crypta_id',
        )

        mobile_utils.set_generate_date(yt_client, mobile_config.APPS_SEGMENTS, nv_params)
        logger.info('Apps segments and daily users tables are calculated.')
