#!/usr/bin/env python
# -*- coding: utf-8 -*-

import json
import logging

from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction
from crypta.lookalike.lib.python.utils import (
    mobile_utils,
    utils,
)
from crypta.lookalike.lib.python.utils.mobile_config import config as mobile_config

logger = logging.getLogger(__name__)


join_features_with_id_type_query = """
INSERT INTO `{features_table}`
WITH TRUNCATE

SELECT
    features.*,
    id_type,
FROM `{features_table}` AS features
INNER JOIN `{crypta_id_to_id_type}` AS id_type_matching
ON id_type_matching.cryptaId == CAST(features.cryptaId AS String);
"""


def get(nv_params, input_file):
    yt_client = mobile_utils.get_yt_client(nv_params=nv_params)
    yql_client = mobile_utils.get_yql_client(nv_params=nv_params)

    if mobile_utils.check_date(yt_client, mobile_config.USERS_FEATURES, nv_params):
        logger.info('Users features table for today is ready.')
        return

    with NirvanaTransaction(yt_client) as transaction:
        with open(input_file, 'r') as dict_file:
            features_mapping = json.load(dict_file)

        utils.get_user_dssm_features(
            yt_client,
            mobile_config.USER_DATA_BY_ALL_CRYPTA_ID,
            mobile_config.USERS_FEATURES,
            features_mapping,
        )

        logger.info('Converted UserData to dssm features')

        yql_client.execute(
            query=join_features_with_id_type_query.format(
                features_table=mobile_config.USERS_FEATURES,
                crypta_id_to_id_type=mobile_config.CRYPTA_ID_TO_ID_TYPE,
            ),
            transaction=str(transaction.transaction_id),
            title='YQL Add id_type to user features',
        )
        logger.info('Joined dssm features with id type')
        mobile_utils.set_generate_date(yt_client, mobile_config.USERS_FEATURES, nv_params)
