import logging

from crypta.lib.python import native_yt
from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction
from crypta.lib.python.yt import (
    schema_utils,
    yt_helpers,
)
from crypta.lookalike.lib.python.utils import utils
from crypta.lookalike.lib.python.utils.config import config
from crypta.lookalike.proto.user_embedding_pb2 import TUserEmbedding
from crypta.lookalike.services.user_dssm_applier.py.native_operations import TApplyUserDssmMapper


logger = logging.getLogger(__name__)


def prepare(nv_params):
    working_dir = nv_params.get('working-dir')
    assert working_dir is not None, 'Model directory is required'

    yt_client = utils.get_yt_client(nv_params=nv_params)

    with NirvanaTransaction(yt_client) as transaction, \
         yt_client.TempTable() as error_table:
        embeddings_table, dssm_files = utils.get_dssm_entities_from_dir(working_dir)

        yt_helpers.create_empty_table(
            yt_client=yt_client,
            path=embeddings_table,
            schema=schema_utils.get_schema_from_proto(TUserEmbedding),
            force=True,
        )
        native_yt.run_native_map(
            mapper_name=TApplyUserDssmMapper,
            source=config.USER_DATA_TABLE,
            destination=[embeddings_table, error_table],
            mapper_files=dssm_files,
            token=yt_client.config['token'],
            pool=yt_client.config['pool'],
            proxy=yt_client.config['proxy']['url'],
            title='TApplyUserDssmMapper',
            transaction=transaction.transaction_id,
        )
