#!/usr/bin/env python
# -*- coding: utf-8 -*-

import logging

from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction
from crypta.lookalike.lib.python.utils.config import config
from crypta.lookalike.lib.python.utils import utils


logger = logging.getLogger(__name__)

add_dssm_features_to_test_segments_query_template = """
INSERT INTO `{test_segments_dssm_features_table}`
WITH TRUNCATE

SELECT segments_dssm_features.*
FROM `{segments_dssm_features_table}` AS segments_dssm_features
INNER JOIN `{test_segments_with_counts_table}` AS test_segments
USING(GroupID);
"""


def add(nv_params):
    yt_client = utils.get_yt_client(nv_params=nv_params)
    yql_client = utils.get_yql_client(nv_params=nv_params)

    with NirvanaTransaction(yt_client) as transaction:
        yql_client.execute(
            query=add_dssm_features_to_test_segments_query_template.format(
                segments_dssm_features_table=config.SEGMENTS_DSSM_FEATURES_TABLE,
                test_segments_with_counts_table=config.TEST_SEGMENTS_WITH_COUNTS_TABLE,
                test_segments_dssm_features_table=config.TEST_SEGMENTS_DSSM_FEATURES_TABLE,
            ),
            transaction=str(transaction.transaction_id),
            title='YQL LaL add dssm features to test segments',
        )
