#!/usr/bin/env python
# -*- coding: utf-8 -*-

import logging

from crypta.lib.python import templater
from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction
from crypta.lookalike.lib.python.utils import utils
from crypta.lookalike.lib.python.utils.config import config


logger = logging.getLogger(__name__)


def apply(nv_params, inputs):
    yt_client = utils.get_yt_client(nv_params=nv_params)
    yql_client = utils.get_yql_client(nv_params=nv_params)

    additional_dssm_fields = []
    if nv_params.get('is_experiment', False) and nv_params.get('use_bow_features', False):
        additional_dssm_fields = utils.get_additional_dssm_fields(
            yt_client,
            utils.get_production_path(config.USER_DSSM_FEATURES_TABLE, nv_params),
            config.USER_DSSM_FEATURES_TABLE,
        )

    with NirvanaTransaction(yt_client) as transaction:
        query = templater.render_template(
            utils.get_users_embeddings_query_template,
            vars={
                'additional_fields': 'segments,',
                'model_path': utils.get_lal_model_source_link(released=config.RELEASED, inputs=inputs),
                'users_dssm_features_table': config.USER_DSSM_FEATURES_TABLE,
                'users_dssm_vectors_table': config.TEST_USERS_DSSM_VECTORS,
                'additional_dssm_fields': additional_dssm_fields,
            }
        )

        yql_client.execute(
            query=query,
            transaction=str(transaction.transaction_id),
            title='YQL LaL get test users dssm embeddings',
        )
