#!/usr/bin/env python
# -*- coding: utf-8 -*-

import logging

from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction
from crypta.lookalike.lib.python.utils import (
    metrics,
    utils,
)
from crypta.lookalike.lib.python.utils.config import config


logger = logging.getLogger(__name__)


def calculate(nv_params):
    yt_client = utils.get_yt_client(nv_params=nv_params)
    yql_client = utils.get_yql_client(nv_params=nv_params)

    with NirvanaTransaction(yt_client) as transaction:
        yql_client.execute(
            query=metrics.calculate_tp_fp_tn_fn_query_template.format(
                order_by='distance',
                group_columns='GroupID',
                input_table=config.TEST_DSSM_LAL_DISTANCES,
                output_table=config.TEST_DSSM_SEGMENTS_POINTS,
            ),
            transaction=str(transaction.transaction_id),
            title='YQL LaL calculate tp fp tn fn for DSSM',
        )
