import logging

from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction
from crypta.lookalike.lib.python.utils import (
    metrics,
    utils,
)
from crypta.lookalike.lib.python.utils.config import config

logger = logging.getLogger(__name__)


def calculate(nv_params, input_table, output_table):
    yt_client = utils.get_yt_client(nv_params=nv_params)
    with NirvanaTransaction(yt_client):
        metrics.get_pr_stats_table(yt_client=yt_client, input_table=input_table, output_table=output_table)


def calculate_random(nv_params):
    calculate(nv_params, config.TEST_RANDOM_SEGMENTS_POINTS, config.TEST_RANDOM_PR_STATS)


def calculate_dssm(nv_params):
    calculate(nv_params, config.TEST_DSSM_SEGMENTS_POINTS, config.TEST_DSSM_PR_STATS)
