#!/usr/bin/env python
# -*- coding: utf-8 -*-

import json
import logging

from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction
from crypta.lookalike.lib.python.utils import (
    fields,
    utils,
)
from crypta.lookalike.lib.python.utils.config import config


logger = logging.getLogger(__name__)


def get(nv_params, output):
    yt_client = utils.get_yt_client(nv_params=nv_params)

    with NirvanaTransaction(yt_client):
        features_mapping = dict()
        for row in yt_client.read_table(config.LAL_FEATURES_MAPPING_TABLE):
            features_mapping[row[fields.feature]] = row[fields.feature_index]
        logger.info('Downloaded features mapping')

        utils.get_segment_dssm_features(
            yt_client=yt_client,
            segments_with_description_table=config.SEGMENTS_USER_DATA_STATS_TABLE,
            segment_dssm_features_table=config.SEGMENTS_DSSM_FEATURES_TABLE,
            features_mapping=features_mapping,
        )

    logger.info('Computed segments dssm features')

    with open(output, 'w') as output_file:
        json.dump(features_mapping, output_file)

    logger.info('Successfully dumped features mapping')
