#!/usr/bin/env python
# -*- coding: utf-8 -*-

import logging

from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction
from crypta.lib.python.yt import yt_helpers
from crypta.lookalike.lib.python.utils import utils
from crypta.lookalike.lib.python.utils.config import config


logger = logging.getLogger(__name__)


def get(nv_params):
    yt_client = utils.get_yt_client(nv_params=nv_params)

    with NirvanaTransaction(yt_client) as transaction:
        utils.describe_segments_in_siberia(
            yt_client,
            config.SEGMENTS_FOR_LAL_TRAINING_TABLE,
            config.SEGMENTS_USER_DATA_STATS_TABLE,
            config.FOR_DESCRIPTION_BY_CRYPTAID_TABLE,
            transaction,
        )

        if not nv_params.get('is_experiment', False):
            yt_helpers.write_stats_to_yt(
                yt_client=yt_client,
                table_path=config.DATALENS_LOOKALIKE_COUNTS_TABLE,
                data_to_write={
                    'counter_name': 'train_val_segments',
                    'count': yt_client.row_count(config.SEGMENTS_USER_DATA_STATS_TABLE),
                },
                schema={
                    'counter_name': 'string',
                    'count': 'uint64',
                },
            )

    logger.info('Successfully computed segments stats')
