#!/usr/bin/env python
# -*- coding: utf-8 -*-

import logging

from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction
from crypta.lookalike.lib.python.utils.config import config
from crypta.lookalike.lib.python.utils import utils


logger = logging.getLogger(__name__)

assign_random_row_rank_query_template = """
INSERT INTO `{output_table}`
WITH TRUNCATE

SELECT
    CAST(yuid AS Uint64) AS yandexuid,
    ROW_NUMBER() OVER w - 1 AS row_rank
FROM `{user_data_table}`
WINDOW w AS (
    ORDER BY RANDOM(yuid)
);
"""


def shuffle(nv_params):
    yt_client = utils.get_yt_client(nv_params=nv_params)
    yql_client = utils.get_yql_client(nv_params=nv_params)

    with NirvanaTransaction(yt_client) as transaction:
        yql_client.execute(
            query=assign_random_row_rank_query_template.format(
                user_data_table=config.USER_DATA_TABLE,
                output_table=config.RANKED_USER_DATA_YANDEXUIDS_TABLE,
            ),
            transaction=str(transaction.transaction_id),
            title='YQL LaL shuffle user data yandexuids',
        )
