#!/usr/bin/env python
# -*- coding: utf-8 -*-

import json
import logging

from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction
from crypta.lookalike.lib.python.utils import utils
from crypta.lookalike.lib.python.utils.config import config


logger = logging.getLogger(__name__)


def get(nv_params, output):
    yt_client = utils.get_yt_client(nv_params=nv_params)
    yql_client = utils.get_yql_client(nv_params=nv_params)

    with NirvanaTransaction(yt_client) as transaction:
        need_full_retrain, features_mapping = utils.compare_feature_mappings(
            yt_client,
            yql_client,
            features_mapping_table=config.LAL_FEATURES_MAPPING_TABLE,
            transaction=transaction,
            is_experiment=nv_params.get('is_experiment', False) if nv_params is not None else False,
        )

        utils.get_user_dssm_features(
            yt_client,
            config.USER_DATA_TABLE,
            config.USER_DSSM_FEATURES_TABLE,
            features_mapping,
            config.USER_DATA_SAMPLING_RATE,
        )

        float_features_size = config.EMBEDDING_FEATURES_SIZE + len(features_mapping)
        yt_client.set_attribute(config.USER_DSSM_FEATURES_TABLE, 'float_features_size', float_features_size)

        logger.info('Converted UserData to dssm features')

        with open(output, 'w') as output_file:
            json.dump({
                'ParamsSize': float_features_size,
                'need_full_retrain': need_full_retrain
            }, output_file)

        logger.info('Successfully dumped features size')
