#!/usr/bin/env python
# -*- coding: utf-8 -*-

import logging

from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction
from crypta.lookalike.lib.python.utils.config import config
from crypta.lookalike.lib.python.utils import utils


logger = logging.getLogger(__name__)

add_test_labels_to_users_query_template = """
$test_segments_by_cryptaid = (
    SELECT
        crypta_id,
        AGGREGATE_LIST_DISTINCT(test.GroupID) AS segments,
    FROM `{test_users_table}` AS test
    LEFT JOIN `{yandexuid_cryptaid_table}` AS yandexuid_cryptaid
    USING(yandexuid)
    GROUP BY COALESCE(yandexuid_cryptaid.crypta_id, test.yandexuid) AS crypta_id
);

$test_segments = (
    SELECT
        COALESCE(cryptaid_yandexuid.yandexuid, test_by_cryptaid.crypta_id) AS yandexuid,
        test_by_cryptaid.segments AS segments,
    FROM $test_segments_by_cryptaid AS test_by_cryptaid
    LEFT JOIN `{cryptaid_yandexuid_table}` AS cryptaid_yandexuid
    USING(crypta_id)
);

INSERT INTO `{user_dssm_features_table}`
WITH TRUNCATE

SELECT
    user_features.*,
    target_segments.segments AS segments,
FROM `{user_dssm_features_table}` AS user_features
LEFT JOIN $test_segments AS target_segments
USING(yandexuid);
"""


def add(nv_params):
    yt_client = utils.get_yt_client(nv_params=nv_params)
    yql_client = utils.get_yql_client(nv_params=nv_params)

    with NirvanaTransaction(yt_client) as transaction:
        float_features_size = yt_client.get_attribute(config.USER_DSSM_FEATURES_TABLE, 'float_features_size')
        yql_client.execute(
            query=add_test_labels_to_users_query_template.format(
                test_users_table=config.TEST_USERS_TABLE,
                yandexuid_cryptaid_table=config.YANDEXUID_CRYPTAID_MATCHING_TABLE,
                cryptaid_yandexuid_table=config.CRYPTAID_YANDEXUID_MATCHING_TABLE,
                user_dssm_features_table=config.USER_DSSM_FEATURES_TABLE,
            ),
            transaction=str(transaction.transaction_id),
            title='YQL LaL add val labels to users',
        )
        yt_client.set_attribute(config.USER_DSSM_FEATURES_TABLE, 'float_features_size', float_features_size)
