#pragma once

#include <crypta/lib/native/yt/utils/tables_indexes.h>
#include <crypta/lib/proto/user_data/user_data.pb.h>
#include <crypta/lookalike/lib/native/user_embedding_model.h>
#include <crypta/lookalike/proto/error.pb.h>
#include <crypta/lookalike/proto/user_embedding.pb.h>

#include <mapreduce/yt/interface/client.h>

#include <util/datetime/base.h>

namespace NCrypta::NLookalike::NUserDssmApplier {
class TApplyUserDssmMapper : public NYT::IMapper<NYT::TTableReader<NLab::TUserData>, NYT::TTableWriter<::google::protobuf::Message>> {
    public:
        enum class EOutputTables {
            Errors,
            UserEmbeddings
        };

        using TOutputIndexes = TTablesIndexes<EOutputTables>;
        using TOutputs = std::tuple<TUserEmbedding, TError>;

        TApplyUserDssmMapper();
        TApplyUserDssmMapper(TOutputIndexes outputIndexes);

        void Start(TWriter* writer) override;
        void Do(TReader* reader, TWriter* writer) override;

        static TOutputIndexes PrepareOutput(NYT::TMapOperationSpec& spec, const TString& embeddings, const TString& errors);

        Y_SAVELOAD_JOB(OutputIndexes);

    private:
        void WriteEmbedding(TWriter* writer, ui64 userId, const TEmbedding& embedding, const NLab::TUserData::TAttributes& attributes);
        void WriteError(TWriter* writer, const TString& message);

        TOutputIndexes OutputIndexes;
        THolder<TUserEmbeddingModel> UserEmbeddingModel;
    };
}
