#pragma once

#include <crypta/lib/native/yt/utils/tables_indexes.h>
#include <crypta/lookalike/proto/user_segments.pb.h>
#include <crypta/lookalike/services/user_segments_exporter/proto/export_user_segments_job_config.pb.h>
#include <crypta/lookalike/services/user_segments_exporter/proto/sharded_user_segment.pb.h>


#include <mapreduce/yt/interface/client.h>

namespace NCrypta::NLookalike::NUserSegmentsExporter {
    class TExportUserSegmentsMapper: public NYT::IMapper<NYT::TTableReader<TUserSegments>, NYT::TTableWriter<TShardedUserSegment>> {
    public:
        TExportUserSegmentsMapper() = default;
        explicit TExportUserSegmentsMapper(TExportUserSegmentsJobConfig config);

        void Do(TReader* reader, TWriter* writer) override;

        Y_SAVELOAD_JOB(Config);

    private:
        TExportUserSegmentsJobConfig Config;

        void Shuffle(TUserSegments& row);
    };
}
