#pragma once

#include <crypta/lib/native/yt/utils/tables_indexes.h>
#include <crypta/lookalike/proto/segment_meta.pb.h>
#include <crypta/lookalike/services/user_segments_exporter/proto/interval.pb.h>
#include <crypta/lookalike/services/user_segments_exporter/proto/sharded_user_segment.pb.h>

#include <mapreduce/yt/interface/client.h>

namespace NCrypta::NLookalike::NUserSegmentsExporter {
    class TExportUserSegmentsReducer: public NYT::IReducer<NYT::TTableReader<TShardedUserSegment>, NYT::TTableWriter< ::google::protobuf::Message>> {
    public:
        enum class EOutputTables {
            Export,
            Errors
        };

        using TOutputIndexes = TTablesIndexes<EOutputTables>;
        using TSegmentMetas = THashMap<ui64, TSegmentMeta>;

        TExportUserSegmentsReducer() = default;
        TExportUserSegmentsReducer(
                TOutputIndexes outputIndexes,
                TInstant exportTs,
                size_t shardsCount,
                TInterval desiredSegmentSize,
                TSegmentMetas segmentMetas);

        void Do(TReader* reader, TWriter* writer) override;

        static TOutputIndexes PrepareOutput(NYT::TOperationOutputSpecBase& spec, const TString& exportTable, const TString& errorsTable);

        Y_SAVELOAD_JOB(OutputIndexes, ExportTs, ShardsCount, DesiredSegmentSize, SegmentMetas);

    private:
        size_t GetDesiredSegmentSize(ui64 segmentId) const;

        void WriteUserSegment(TWriter* writer, ui64 userId, ui64 segmentId);
        void WriteError(TWriter* writer, ui64 segmentId, const TString& message);

        TOutputIndexes OutputIndexes;
        TInstant ExportTs;
        size_t ShardsCount = 0;
        TInterval DesiredSegmentSize;
        TSegmentMetas SegmentMetas;
    };
}
