#pragma once

#include <crypta/lib/native/yt/utils/tables_indexes.h>

#include <mapreduce/yt/interface/client.h>

namespace NCrypta::NLookalike::NVisitLogParser {
    class TParseVisitLogMapper: public NYT::IMapper<NYT::TTableReader<NYT::TNode>, NYT::TTableWriter<::google::protobuf::Message>> {
    public:
        enum class EOutputTables {
            CounterVisits,
            GoalAchievements,
            Errors
        };

        using TOutputIndexes = TTablesIndexes<EOutputTables>;

        TParseVisitLogMapper() = default;
        TParseVisitLogMapper(TOutputIndexes outputIndexes);

        void Do(TReader* reader, TWriter* writer) override;

        Y_SAVELOAD_JOB(OutputIndexes);

    private:
        void ParseCounterVisit(TWriter* writer, ui64 yandexuid, const NYT::TNode& node);
        void ParseGoalAchievements(TWriter* writer, ui64 yandexuid, const NYT::TNode& node);

        void WriteCounterVisit(TWriter* writer, ui64 yandexuid, ui64 counterId, ui64 ts);
        void WriteGoalAchievement(TWriter* writer, ui64 yandexuid, ui64 goalId, ui64 ts);
        void WriteError(TWriter* writer, const TString& message);

        TOutputIndexes OutputIndexes;
    };
}
