import logging

import yt.clickhouse as chyt
import yt.wrapper as yt

from crypta.lib.python import templater
from crypta.ltp.viewer.lib.compact_index.py import pack_index
from crypta.ltp.viewer.lib.structs.id import Id


logger = logging.getLogger(__name__)


class ChytClient:
    def __init__(self, yt, alias):
        self.yt = yt
        self.alias = alias

    def get_logs_from_index(self, ids, index_path):
        query = templater.render_resource("/queries/get_logs_from_index.sql", {"ids": ids, "path": index_path})
        raw_responses = list(chyt.execute(
            query,
            alias=self.alias,
            client=self.yt,
            raw=True
        ))

        responses = [row.split(b'\t') for row in raw_responses]

        result = {
            Id(response[0].decode(), response[1].decode()): pack_index.unpack(response[2].decode("unicode_escape").encode("latin1"))
            for response in responses
        }
        logger.info("%s", result)
        return result

    def get_entries_from_logs(self, id, log_path, date, column_names, column_code):
        present_columns = {
            column["name"]
            for column in self.yt.get_attribute(yt.ypath_join(log_path, date), "schema")
            if column["name"] in column_names
        }
        results = chyt.execute(
            templater.render_resource("/queries/get_entries_from_logs.sql", dict(
                id._asdict(),
                path=log_path,
                date=date,
                columns=[column_code[column] for column in present_columns]
            )),
            alias=self.alias,
            client=self.yt,
        )
        return results
