#include "pack_index.h"

#include <crypta/lib/native/proto_serializer/proto_serializer.h>
#include <crypta/ltp/viewer/proto/index.pb.h>

#include <util/datetime/base.h>
#include <util/generic/algorithm.h>
#include <util/generic/set.h>

#include <algorithm>
#include <iterator>
#include <numeric>


TString NCrypta::NLtpViewer::NProtoIndex::Pack(TLogDates&& logDates) {
    NCrypta::NLtpViewer::TIndex index;

    for (auto& [logType, days]: logDates) {
        auto& log = *index.AddLogs();

        NCrypta::NLtpViewer::ELogType logTypeEnum;
        Y_ENSURE(NCrypta::NLtpViewer::ELogType_Parse(logType, &logTypeEnum));
        log.SetType(logTypeEnum);

        log.MutableDayDiffs()->Resize(days.size(), 0);
        std::adjacent_difference(days.begin(), days.end(), log.MutableDayDiffs()->begin());
    }

    TString serialized;
    Y_ENSURE(index.SerializeToString(&serialized));
    return serialized;
}

NCrypta::NLtpViewer::NProtoIndex::TLogDates NCrypta::NLtpViewer::NProtoIndex::Unpack(const TString& serializedIndex) {
    NCrypta::NLtpViewer::TIndex index;
    NCrypta::NProtoSerializer::FromString(index, serializedIndex);

    TLogDates buffer;

    for (const auto& log : index.GetLogs()) {
        auto logTypeStr = NCrypta::NLtpViewer::ELogType_Name(log.GetType());
        auto& days = buffer[logTypeStr];

        std::partial_sum(log.GetDayDiffs().begin(), log.GetDayDiffs().end(), std::inserter(days, days.begin()));
    }

    return buffer;
}
