from cython.operator cimport dereference
from libcpp.utility cimport move
import datetime

import six
from util.generic.hash cimport THashMap
from util.generic.string cimport TString

from crypta.ltp.viewer.lib.compact_index.py.set cimport TSet


cdef extern from "crypta/ltp/viewer/lib/compact_index/pack_index.h" namespace "NCrypta::NLtpViewer::NProtoIndex" nogil:
    cdef THashMap[TString, TSet[int]] Unpack(const TString& buffer) except +;
    cdef TString Pack(THashMap[TString, TSet[int]]&& buffer) except +;


def _days_to_date_str(date_int):
    return (datetime.date.fromtimestamp(0) + datetime.timedelta(days=date_int)).isoformat()


def _date_str_to_days(date_str):
    return (datetime.date.fromisoformat(date_str) - datetime.date.fromtimestamp(0)).days


def unpack(serialized_index):
    buffer = Unpack(serialized_index)
    return {
        pair.first.decode(): [_days_to_date_str(date) for date in pair.second]
        for pair in buffer
    }


def pack(index):
    cdef THashMap[TString, TSet[int]] buffer
    for log, dates in index.items():
        for date in dates:
            buffer[log.encode()].insert(_date_str_to_days(date))

    return Pack(move(buffer))
