from crypta.ltp.viewer.proto import index_pb2
from crypta.ltp.viewer.lib.ltp_logs import (
    columns,
    records,
)


class Log:
    def __init__(self, log_type, columns, additional_columns=None):
        self.log_type = log_type
        enum = index_pb2.ELogType.DESCRIPTOR.values_by_number[log_type]
        self.name = enum.name
        self.path = enum.GetOptions().Extensions[index_pb2.custom_path] or "//home/bs/logs/{}/1d".format(enum.name)
        self.columns = columns
        self.additional_columns = additional_columns or records.ListRecordFormat([])

    @property
    def yt_columns(self):
        return self.columns.yt_columns | self.additional_columns.yt_columns

    @property
    def chyt_columns(self):
        return self.columns.chyt_columns | self.additional_columns.chyt_columns

    def format_description(self, record, context):
        return self.columns.format(record, context)

    def format_additional_description(self, record, context):
        return self.additional_columns.format(record, context)


LOGS = (
    Log(
        index_pb2.LtpWatch,
        records.ListRecordFormat([
            columns.ColumnNamedFormat("SearchQuery"),
            columns.ColumnNamedFormat("Title"),
            columns.ColumnNamedFormat("LinkText"),
            columns.URLColumnNamedFormat("Referer"),
            columns.URLColumnNamedFormat("Url"),
        ]),
        records.ListRecordFormat([
            columns.LtpWatchAdditionalDescriptionFormat(),
        ]),
    ),
    Log(
        index_pb2.LtpVisitStates,
        records.ListRecordFormat([
            columns.ColumnNamedFormat("Duration"),
            columns.YsonColumnNamedFormat("Goals_ID"),
            columns.URLColumnNamedFormat("Referer"),
            columns.URLColumnNamedFormat("StartURL"),
            columns.URLColumnNamedFormat("StartURLDomain"),
            columns.URLColumnNamedFormat("LinkURL"),
        ]),
    ),
    Log(
        index_pb2.UserSessionQueries,
        records.ListRecordFormat([
            columns.ColumnNamedFormat("Query"),
            columns.ColumnNamedFormat("CorrectedQuery"),
            columns.GeoColumnNamedFormat("RelevRegionID", "RelevRegionName"),
            columns.GeoColumnNamedFormat("SearchRegion", "SearchRegionName"),
        ]),
    ),
    Log(
        index_pb2.UserSessionClickedDocs,
        records.ListRecordFormat([
            columns.ColumnNamedFormat("Query"),
            columns.ColumnNamedFormat("CorrectedQuery"),
            columns.ColumnNamedFormat("OmniTitle"),
            columns.ColumnNamedFormat("DocumentUrl"),
            columns.ColumnNamedFormat("RelevRegionNameRusV2"),
            columns.ColumnNamedFormat("Title"),
            columns.URLColumnNamedFormat("Url"),
        ]),
    ),
    Log(
        index_pb2.LtpEcom,
        records.ListRecordFormat([
            columns.ColumnNamedFormat("CounterID"),
            columns.ColumnNamedFormat("OfferID"),
            columns.ColumnNamedFormat("OfferIDMd5"),
            columns.ColumnNamedFormat("OfferName"),
            columns.ColumnNamedFormat("OfferPrice"),
            columns.ColumnNamedFormat("OfferSource"),
            columns.ColumnNamedFormat("ActionType"),
            columns.ColumnNamedFormat("OfferBrand"),
            columns.ColumnNamedFormat("OfferCategory"),
            columns.ColumnNamedFormat("OfferCoupon"),
        ]),
    ),
    Log(
        index_pb2.CryptaTxLog,
        records.ListRecordFormat([
            columns.ColumnNamedFormat("Source"),
            columns.ColumnNamedFormat("Seller"),
            columns.GeoColumnNamedFormat("GeoId", "RegionName", "Region"),
            columns.CryptaTxDescription(),
            columns.CryptaTxPriceFormat("ItemUnitPriceRub", "Price"),
        ]),
    ),
    Log(
        index_pb2.LtpBrowserUrlTitle,
        records.ListRecordFormat([
            columns.ColumnNamedFormat("EventName"),
            columns.ColumnNamedFormat("Title"),
            columns.ColumnNamedFormat("Yasoft"),
            columns.ColumnNamedFormat("APIKey"),
        ]),
    ),
    Log(
        index_pb2.LtpVisitGoalsV2,
        records.ListRecordFormat([
            columns.ColumnNamedFormat("CounterName"),
            columns.ColumnNamedFormat("GoalName"),
            columns.YsonColumnNamedFormat("GoalPatternTypes"),
            columns.YsonColumnNamedFormat("GoalPatternUrls"),
            columns.ColumnNamedFormat("GoalType"),
            columns.ColumnNamedFormat("ReachedCounter"),
            columns.ColumnNamedFormat("ReachedGoal"),
            columns.ColumnNamedFormat("Autobudget"),
        ]),
    ),
) + tuple(
    Log(
        log_type,
        records.ListRecordFormat([
            columns.ColumnNamedFormat("BannerText"),
            columns.ColumnNamedFormat("BannerTitle"),
            columns.ColumnNamedFormat("SecondTitle"),
            columns.ColumnNamedFormat("SelectType"),
            columns.GeoColumnNamedFormat("RegionID", "RegionName"),
            columns.ColumnNamedFormat("BannerURL"),
            columns.ColumnNamedFormat("URLClusterID"),
            columns.ColumnNamedFormat("ProductType"),
            columns.ColumnNamedFormat("BannerID"),
            columns.PageFormat("PageID", "PageName", "PageDescription"),
            columns.URLColumnNamedFormat("Referer"),
            columns.CategoryFormat("BMCategory1ID"),
            columns.CategoryFormat("BMCategory2ID"),
            columns.CategoryFormat("BMCategory3ID"),
            columns.CategoryFormat("BMCategoryID"),
        ]),
        records.ListRecordFormat([
            columns.LtpRsyaClicksAdditionalDescriptionFormat(),
        ]),
    )
    for log_type in [index_pb2.LtpRsyaShows, index_pb2.LtpRsyaClicks, index_pb2.LtpSearchClicks, index_pb2.LtpSearchShows, index_pb2.LtpLocalAds]
)

LOGS_DICT = {
    log.log_type: log
    for log in LOGS
}
