from cached_property import cached_property


class RecordFormat:
    @cached_property
    def yt_columns(self):
        raise NotImplementedError

    def format(self, record, context):
        raise NotImplementedError


class ListRecordFormat(RecordFormat):
    def __init__(self, columns):
        self.columns = columns

    @cached_property
    def yt_columns(self):
        return set().union(*(set(column.columns) for column in self.columns))

    @cached_property
    def chyt_columns(self):
        return {
            k: v
            for column in self.columns
            for k, v in column.chyt_columns.items()
        }

    def format(self, record, context):
        return "\n".join(
            item
            for column in self.columns
            for item in column.format(record, context)
            if item is not None
        )
