import datetime
import typing

from crypta.ltp.viewer.lib.structs.ydb_params import ydb_params


def get_timestamp(ts, date):
    if not ts and date:
        return int(datetime.datetime.timestamp(datetime.datetime.fromisoformat(date)))
    return ts or None


@ydb_params
class Filter(typing.NamedTuple):
    min_timestamp: int = None
    max_timestamp: int = None
    log_filter: str = None
    id_filter: str = None
    id_type_filter: str = None
    description_filter: str = None
    additional_description_filter: str = None

    @staticmethod
    def from_proto(proto, from_date=None, to_date=None):
        return Filter(
            min_timestamp=get_timestamp(proto.MinTimestamp, from_date),
            max_timestamp=get_timestamp(proto.MaxTimestamp, to_date),
            log_filter=proto.LogFilter or None,
            id_filter=proto.IdFilter or None,
            id_type_filter=proto.IdTypeFilter or None,
            description_filter=proto.DescriptionFilter or None,
            additional_description_filter=proto.AdditionalDescriptionFilter or None,
        )
