DECLARE $min_timestamp AS Datetime?;
DECLARE $max_timestamp AS Datetime?;
DECLARE $log_filter AS Utf8?;
DECLARE $id_filter AS Utf8?;
DECLARE $id_type_filter AS Utf8?;
DECLARE $description_filter AS Utf8?;
DECLARE $additional_description_filter AS Utf8?;

$filtered = (
    SELECT * FROM `{{history_id}}/log`
    WHERE
        ($min_timestamp IS NULL OR $min_timestamp <= `timestamp`) AND
        ($max_timestamp IS NULL OR $max_timestamp >= `timestamp`) AND
        ($log_filter IS NULL OR $log_filter = log) AND
        ($id_filter IS NULL OR $id_filter = id) AND
        ($id_type_filter IS NULL OR $id_type_filter = id_type) AND
        ($description_filter IS NULL OR Unicode::Find(description, Unwrap($description_filter)) != -1) AND
        ($additional_description_filter IS NULL OR Unicode::Find(additional_description, Unwrap($additional_description_filter)) != -1)
);
