DECLARE $limit AS Uint64;

$date_format = DateTime::Format('%Y-%m-%d');

$to_update = (
    SELECT
        id,
        id_type,
        log,
        `date`,
        CAST('running' AS Utf8) AS status,
    FROM `{{ history_id }}/progress`
    WHERE status = 'scheduled'
    ORDER BY `date` DESC
    LIMIT $limit
);

SELECT
    id,
    id_type,
    log,
    CAST($date_format(`date`) AS Utf8) AS `date`,
FROM $to_update;

UPDATE `{{ history_id }}/progress` ON
SELECT * FROM $to_update;
