DECLARE $offset AS Uint64;
DECLARE $limit AS Uint64;
DECLARE $from_date AS Utf8?;
DECLARE $to_date AS Utf8?;

$date_format = DateTime::Format('%Y-%m-%d');

SELECT
    id,
    id_type,
    log,
    CAST($date_format(`date`) AS Utf8) AS `date`,
    status,
    create_time,
    complete_time,
FROM `{{ history_id }}/progress`
WHERE
    (($from_date ?? '' == '') OR $from_date <= CAST($date_format(`date`) AS Utf8)) AND
    (($to_date ?? '' == '') OR $to_date >= CAST($date_format(`date`) AS Utf8))
LIMIT $limit OFFSET $offset;
