DECLARE $tasks AS List<Struct<
    id_type: Utf8,
    id: Utf8,
    log: Utf8,
    `date`: Utf8,
>>;
DECLARE $timestamp AS Datetime?;

UPSERT INTO `{{ history_id }}/progress`
SELECT
    id,
    id_type,
    log,
    DateTime::MakeDate(DateTime::ParseIso8601(`date`)) AS `date`,
    CAST("scheduled" AS Utf8) AS status,
    $timestamp AS create_time,
    Nothing(Datetime?) AS complete_time,
FROM AS_TABLE($tasks);
