import ydb


ID_TO_HISTORY_ID_SCHEMA = (ydb.TableDescription()
                           .with_column(ydb.Column('id', ydb.OptionalType(ydb.PrimitiveType.Utf8)))
                           .with_column(ydb.Column('id_type', ydb.OptionalType(ydb.PrimitiveType.Utf8)))

                           .with_column(ydb.Column('history_id', ydb.OptionalType(ydb.PrimitiveType.Utf8)))
                           .with_column(ydb.Column('timestamp', ydb.OptionalType(ydb.PrimitiveType.Datetime)))

                           .with_primary_keys('id', 'id_type'))

PROGRESS_SCHEMA = (ydb.TableDescription()
                   .with_column(ydb.Column('id', ydb.OptionalType(ydb.PrimitiveType.Utf8)))
                   .with_column(ydb.Column('id_type', ydb.OptionalType(ydb.PrimitiveType.Utf8)))
                   .with_column(ydb.Column('log', ydb.OptionalType(ydb.PrimitiveType.Utf8)))
                   .with_column(ydb.Column('date', ydb.OptionalType(ydb.PrimitiveType.Date)))

                   .with_column(ydb.Column('status', ydb.OptionalType(ydb.PrimitiveType.Utf8)))
                   .with_column(ydb.Column('create_time', ydb.OptionalType(ydb.PrimitiveType.Datetime)))
                   .with_column(ydb.Column('complete_time', ydb.OptionalType(ydb.PrimitiveType.Datetime)))

                   .with_primary_keys('id', 'id_type', 'log', 'date'))

LOG_SCHEMA = (ydb.TableDescription()
              .with_column(ydb.Column('timestamp', ydb.OptionalType(ydb.PrimitiveType.Datetime)))
              .with_column(ydb.Column('hash', ydb.OptionalType(ydb.PrimitiveType.Uint64)))

              .with_column(ydb.Column('log', ydb.OptionalType(ydb.PrimitiveType.Utf8)))
              .with_column(ydb.Column('id', ydb.OptionalType(ydb.PrimitiveType.Utf8)))
              .with_column(ydb.Column('id_type', ydb.OptionalType(ydb.PrimitiveType.Utf8)))
              .with_column(ydb.Column('description', ydb.OptionalType(ydb.PrimitiveType.Utf8)))
              .with_column(ydb.Column('additional_description', ydb.OptionalType(ydb.PrimitiveType.Utf8)))

              .with_primary_keys('timestamp', 'hash'))


USER_QUERIES_SCHEMA = (ydb.TableDescription()
                          .with_column(ydb.Column('owner', ydb.OptionalType(ydb.PrimitiveType.Utf8)))
                          .with_column(ydb.Column('id', ydb.OptionalType(ydb.PrimitiveType.Utf8)))
                          .with_column(ydb.Column('id_type', ydb.OptionalType(ydb.PrimitiveType.Utf8)))
                          .with_column(ydb.Column('from_date', ydb.OptionalType(ydb.PrimitiveType.Utf8)))
                          .with_column(ydb.Column('to_date', ydb.OptionalType(ydb.PrimitiveType.Utf8)))
                          .with_column(ydb.Column('timestamp', ydb.OptionalType(ydb.PrimitiveType.Datetime)))

                          .with_primary_keys('owner', 'id', 'id_type', 'from_date', 'to_date'))
